Attribute VB_Name = "cextex_bas"
'=======================================================
'  Interface Esttica para CERTEX.DLL
'    ou load-time dynamic linking to CERTEX.DLL
'
'  Certex.dll 1.0
'  'Certex- A DLL que confere'
'  Biblioteca Certificadora de Documentos
'
'   (c) 2002 Software Atelier
'       www.satelier.com.br
'
'=======================================================

Option Explicit

'---- Tipos de documentos
Public Const certex_doc_type_CNPJ = 0
Public Const certex_doc_type_CPF = 1
Public Const certex_doc_type_PIS = 2     ' Programa de Integrao Social
Public Const certex_doc_type_TITULO = 3  ' Ttulo de Eleitor
Public Const certex_doc_type_IE = 4      ' Inscrio Estadual
Public Const certex_doc_type_CC = 5      ' Carto de Crdito

'---- Resultados de certex_isValid() e certex_isCreditCard()
Public Const certex_result_VALIDO = 0
Public Const certex_result_INVALIDO = 1
Public Const certex_result_TIPO_DOC_DESCONHECIDO = 2
Public Const certex_result_SEM_NUM_DOC = 3
Public Const certex_result_NUM_DOC_CHR_INVALIDO = 4
Public Const certex_result_NUM_DOC_LEN_INVALIDO = 5
Public Const certex_result_UF_DESCONHECIDA = 6
Public Const certex_result_MUNICIPIO_DESCONHECIDO = 7
Public Const certex_result_DESCONHECIDO = 10

'---- Resultados de certex_getLicType()
Public Const certex_lic_ERROR_UNKNOW = 0
Public Const certex_lic_TYPE_REGISTERED = 1
Public Const certex_lic_TYPE_DEMO = 2
Public Const certex_lic_TYPE_AS_DEMO = 3
Public Const certex_lic_ERROR_NOT_INITED = 4
Public Const certex_lic_ERROR_CANT_RETRIVE = 5
Public Const certex_lic_ERROR_NOT_FOUND = 6
Public Const certex_lic_ERROR_CRC = 7
Public Const ceretx_lic_ERROR_INVALID_KEY = 8

'---- Solicitaes para certex_getLicInfo()
Private Const certex_lic_info_USER_NAME = 1
Private Const certex_lic_info_USER_ID = 2

'----- Resultados de certex_isDigit()
Public Const certex_digits_OK = 0
Public Const certex_digits_INVALIDO = 1
Public Const certex_digits_FALTAM = 2
Public Const certex_digits_SOBRAM = 3
Public Const certex_digits_ERRO = 4

'---- Counts
Public Const certex_UF_Count As Byte = 27
Public Const certex_Doc_Type_Count As Byte = 6


'---- Size
Public Const certex_max_flag_size = 14

'---- Aux
Public Const certex_dll_name As String = "Certex.dll"

'-----------------------------------------
'------- DLL exported Public Declarations
'-- Informao DLL
Public Declare Function certex_getLicType Lib "certex.dll" (Optional ByVal strLicNum As String = vbNullString) As Byte

'-- Validao
Public Declare Function certex_isValid Lib "certex.dll" (ByVal bytInfoType As Byte, ByVal lpDocUF As String, ByVal lpDocNum As String) As Byte
Public Declare Function certex_isDigit Lib "certex.dll" (ByVal bytDocType As Byte, ByVal lpDocUF As String, ByVal lpDocNum As String, ByRef lngDigits As Long) As Byte

'-- Formatao
Public Declare Function certex_getQntDigits Lib "certex.dll" (ByVal bytDocType As Byte, ByVal lpDocUF As String, ByVal lpDocNum As String) As Byte

'-----------------------------------------
'------- DLL exported Hidden Declarations  (easer buffer manipulation)
'-- Informao DLL
Private Declare Function certex_getVersion Lib "certex.dll" () As Integer
Private Declare Function certex_getLicInfo Lib "certex.dll" (ByVal bytInfoType As Byte, ByVal lngBufferLen As Long, ByVal lpName As String) As Long

'-- Validao
Private Declare Function certex_isCreditCard Lib "certex.dll" (ByVal lpCC_Num As String, ByVal lngBufferLen As Long, ByVal lpBuffer As String) As Byte

'-- Auxiliares
Private Declare Function certex_getDocName Lib "certex.dll" (ByVal bytDocType As Byte, ByVal lngBufferLen As Long, ByVal lpName As String) As Long
Private Declare Function certex_getUFName Lib "certex.dll" (ByVal bytN As Byte, ByVal blnShortName As Long, ByVal lpName As String) As Long

'-- Formatao
Private Declare Function certex_getFormat Lib "certex.dll" (ByVal bytDocType As Byte, ByVal lpDocUF As String, ByVal lpDocNum As String, ByVal lngBufferLen As Long, ByVal lpBuffer As String) As Long
Private Declare Function certex_setFormat Lib "certex.dll" (ByVal bytDocType As Byte, ByVal lpDocUF As String, ByVal lpDocNum As String, ByVal lngBufferLen As Long, ByVal lpBuffer As String) As Long

'-----------------------------------------
'------- Funes Derivadas (string )
Private Const cextex_max_info = 100

Public Function certex_docName(bytDocType As Byte) As String
  Dim strName As String

  strName = String(cextex_max_info, Chr(0))
  certex_docName = Left(strName, certex_getDocName(bytDocType, Len(strName), strName))

End Function
Public Function certex_UFName(bytUF As Byte, blnShortName As Boolean) As String
  Dim lngSize As Long
  Dim lngBool As Long

  lngBool = blnShortName
  lngSize = certex_getUFName(bytUF, lngBool, vbNullString)
  If (lngSize = 0) Then
    certex_UFName = ""
  Else
    certex_UFName = String(lngSize, Chr(0))
    certex_getUFName bytUF, lngBool, certex_UFName
  End If

End Function

Private Function getInfo(bytInfoType As Byte) As String
  Dim strInfo As String

  strInfo = String(cextex_max_info, Chr(0))
  getInfo = Left(strInfo, certex_getLicInfo(bytInfoType, Len(strInfo), strInfo))

End Function

Public Function certex_licNum() As String

  certex_licNum = getInfo(certex_lic_info_USER_ID)

End Function
Public Function certex_licUser() As String

  certex_licUser = getInfo(certex_lic_info_USER_NAME)

End Function
Public Function certex_dllVersion() As String
  Dim lngVersion As Long

  lngVersion = certex_getVersion()
  certex_dllVersion = Trim(Str(lngVersion \ &HFF)) & "," & Trim(Str(lngVersion And &HFF))

End Function

Public Function certex_format(bytDocType As Byte, strDocUF As String, strDocNum As String) As String
  Dim lngSize As Long

  lngSize = certex_getFormat(bytDocType, strDocUF, strDocNum, 0, vbNullString)
  If (lngSize = 0) Then
    certex_format = ""
  Else
    certex_format = String(lngSize, Chr(0))
    certex_setFormat bytDocType, strDocUF, strDocNum, lngSize, certex_format
  End If

End Function
Public Function certex_creditCardFlag(strCC_Num As String) As String
  Dim lngSize As Long
  Dim strBuffer As String

  strBuffer = String(cextex_max_info + 1, Chr(0))
  If Not (certex_isCreditCard(strCC_Num, Len(strBuffer), strBuffer) = certex_result_VALIDO) Then
    certex_creditCardFlag = ""
  ElseIf (strBuffer = vbNullString) Then
    certex_creditCardFlag = "Bandeira desconhecida"
  Else
    certex_creditCardFlag = Left(strBuffer, InStr(strBuffer, Chr(0)) - 1)
  End If

End Function
