unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids, StdCtrls, ExtCtrls;

type
  TformMain = class(TForm)
    panelButtons: TPanel;
    buttonVerify: TButton;
    dbGridMain: TDBGrid;
    tableMain: TTable;
    dataSourceMain: TDataSource;
    tableMainESTADO: TStringField;
    tableMainINSCRICAO: TStringField;
    tableMainOK: TBooleanField;
    tableMainCERTEX: TStringField;
    staticTextInfo: TStaticText;
    buttonAbout: TButton;
    procedure buttonVerifyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure buttonAboutClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  formMain: TformMain;
  abort: boolean= false;

implementation
  uses
    certex_pas, uAbout;

  const
    _destroyMe= 2;

{$R *.DFM}

//==============================================================================
procedure TformMain.FormCreate(Sender: TObject);
begin

  staticTextInfo.Caption:= Application.Title;

                 // Nmero de Registro
  certex_getLicType( {'LicKey'} );
  buttonVerify.Enabled:= tableMain.Active;

end;

//==============================================================================
procedure TformMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  if ( formAbout = nil ) then begin  // no criei
    //
  end else if ( formAbout.tag = _destroyMe ) then begin // criei
    formAbout.free;
  end;

end;

//==============================================================================
procedure TformMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin

  abort:= true;

end;

//==============================================================================
procedure TformMain.buttonVerifyClick(Sender: TObject);
  var
    iSize, iResult: byte;
    cInsEs: string;
    nQnt, nErro: integer;
    dtStart: TDateTime;
begin

  abort:= false;
  buttonVerify.Enabled:= false;
  Screen.Cursor:= crHourGlass;
  // para obter maior velocidade, descomentar a linha abaixo
  // tableMain.DisableControls;
  try
    nQnt:= 0;
    nErro:= 0;
    tableMain.First;
    dtStart:= now();
    while not tableMain.Eof and not abort do begin
      cInsEs:= trim( tableMainINSCRICAO.AsString );

     // completar com zero a esquerda
      iSize:= certex_getQntDigits( certex_doc_type_IE, pChar( tableMainESTADO.asString ), pChar( cInsEs  ));
      if ( length( cInsEs ) < 3 ) then begin
        // ignore
      end else if ( length( cInsEs ) < iSize ) then begin
        cInsEs:= stringofChar( '0', iSize - length( cInsEs ) ) + cInsEs;
      end;

     // validar
      iResult:= certex_isValid( certex_doc_type_IE, pChar( tableMainESTADO.asString ), pChar( cInsEs  ));
      inc( nQnt );
      if not ( iResult = certex_result_VALIDO ) then begin
        inc( nErro );
      end;
      tableMain.edit;
      tableMainCERTEX.AsInteger:= iResult;
      tableMain.Post;
      tableMain.Next;
      application.ProcessMessages;
    end;
    MessageDlg(
        Format('Tabela "%s" conferida em %s.%s%d registro(s) %d Errado(s).',
          [ tableMain.TableName, FormatDateTime( 'h:nn:ss.zzz', now() - dtStart ), #10#13, nQnt, nErro] ),
        mtInformation,
        [ mbOK ],
        0);
  finally
    Screen.Cursor:= crDefault;
    buttonVerify.Enabled:= true;
    tableMain.EnableControls;
  end;

end;

//==============================================================================
procedure TformMain.buttonAboutClick(Sender: TObject);
begin

  if ( formAbout = nil ) then begin
    formAbout:= TFormAbout.Create( self );
    formAbout.tag:= _destroyMe;
  end;

  formAbout.Position:= poOwnerFormCenter;
  formAbout.showModal();

end;

end.
