unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TformMain = class(TForm)
    comboBoxDocType: TComboBox;
    labelUF: TLabel;
    comboBoxUF: TComboBox;
    labelDocNum: TLabel;
    editDocNum: TEdit;
    labelResult: TLabel;
    editResult: TEdit;
    buttonAbout: TButton;
    buttonVerify: TButton;
    buttonClose: TButton;
    labelDocType: TLabel;
    staticTextInfo: TStaticText;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure editDocNumChange(Sender: TObject);
    procedure comboBoxDocTypeChange(Sender: TObject);
    procedure buttonAboutClick(Sender: TObject);
    procedure buttonCloseClick(Sender: TObject);
    procedure buttonVerifyClick(Sender: TObject);
  private
    FCertexLic: byte;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  formMain: TformMain;

implementation
  uses
    uAbout,
    certex_pas;

  const
    _destroyMe= 2;

{$R *.DFM}
//==============================================================================
procedure TformMain.FormCreate(Sender: TObject);
  var
    i: byte;
begin

  staticTextInfo.Caption:= application.Title;

 // Inicializar DLL, aqui pasar a chave de Registro obtida via e-mail
  FCertexLic:= certex_getLicType( {'LicKey'} );
 // Para conhecer os posiveis valores de retorno, ver buttonAboutClick


 // Carregar tipos de documentos que Certex Verifica
  for i:= 0 to certex_Doc_Type_Count - 1 do begin
    comboBoxDocType.Items.Add( certex_docName( i ) );
  end;
  comboBoxDocType.ItemIndex:= 0;
  comboBoxDocTypeChange( nil );  // refresh

 // Carregar os UF (sigla, extenso)
  for i:= 0 to certex_UF_Count - 1 do begin
    comboBoxUF.Items.Add( Format( '%s, %s', [certex_UFName( i, true ), certex_UFName( i, false )]));
  end;
  comboBoxUF.ItemIndex:= 0;

end;

//==============================================================================
procedure TformMain.buttonVerifyClick(Sender: TObject);
  var
    tipoDoc, iResult: byte;
    iDigit: integer;
begin

  tipoDoc:= comboBoxDocType.ItemIndex;

 //---- Na verso de Avaliao, demora em dar o resultado
 //     mostrar ao usuario a demora (no seja empaciente e ctrl + alt + del
  if not ( FCertexLic = certex_lic_TYPE_REGISTERED ) then begin
    editResult.Text:= 'Conferindo... (verso demo)';
    editResult.refresh;
    screen.Cursor:= crHourGlass;
    buttonVerify.Enabled:= false;
  end;

 //---- Verificar
  iResult:= certex_isValid( tipoDoc, pChar(comboBoxUF.text), pChar( editDocNum.Text ) );

 //---- voltar mouse, etc
  if not ( FCertexLic = certex_lic_TYPE_REGISTERED ) then begin
    screen.Cursor:= crDefault;
    buttonVerify.Enabled:= true;
  end;

  //---- Mostrar resultado
  if ( iResult = certex_result_VALIDO ) then begin
    editResult.Text:= certex_format( tipoDoc, pChar(comboBoxUF.text), pChar( editDocNum.Text ) );
    if ( tipoDoc = certex_doc_type_CC ) then begin
      editResult.Text:= Format( '%s (%s)', [ editResult.Text, certex_creditCardFlag( pChar( editDocNum.Text )) ]);
    end else begin
      editResult.Text:= editResult.Text + ' Ok!';
    end;
  end else { documento invlido, mostrar razo} begin
    messageBeep( MB_ICONEXCLAMATION );
    case iResult of
      certex_result_INVALIDO:               editResult.Text:= comboBoxDocType.text + ' invlido(a).';
      certex_result_SEM_NUM_DOC:            editResult.text:= 'Informe o nmero de documento.';
      certex_result_TIPO_DOC_DESCONHECIDO:  editResult.text:= 'Tipo de documento desconhecido.';
      certex_result_UF_DESCONHECIDA:        editResult.text:= 'Unidade Federativa desconhecida.';
      certex_result_MUNICIPIO_DESCONHECIDO: editResult.text:= 'Municpio de desconhecido.';
      certex_result_NUM_DOC_CHR_INVALIDO:
        begin
          editResult.text:= 'Caracter invlido encontrado no nmero.';
          certex_isDigit( tipoDoc, pChar(comboBoxUF.text), pChar( editDocNum.Text ), iDigit );
          editDocNum.SetFocus();
          editDocNum.SelStart:= iDigit;
          editDocNum.SelLength:= 1;
        end;
      certex_result_NUM_DOC_LEN_INVALIDO:
        begin
          editResult.text:= 'Nmero invlido de digitos.';
          if not (tipoDoc = certex_doc_type_CC ) then begin
            editResult.text:= format( '%s Esperados %d.', [editResult.text, certex_getQntDigits( tipoDoc, pChar(comboBoxUF.text), pChar( editDocNum.Text ))] )
          end;
        end;
    else
      editResult.text:= Format( 'Documento invlido (Erro: %d)', [iResult]);
    end;
  end;

end;

//==============================================================================
procedure TformMain.FormDestroy(Sender: TObject);
begin

  if ( formAbout = nil ) then begin  // no criei
    //
  end else if ( formAbout.tag = _destroyMe ) then begin // criei
    formAbout.free;
  end;

end;

//==============================================================================
procedure TformMain.buttonAboutClick(Sender: TObject);
begin

  if ( formAbout = nil ) then begin
    formAbout:= TFormAbout.Create( self );
    formAbout.tag:= _destroyMe;
  end;

  formAbout.Position:= poOwnerFormCenter;
  formAbout.showModal();

end;

//==============================================================================
procedure TformMain.buttonCloseClick(Sender: TObject);
begin

  close;

end;

//==============================================================================
procedure TformMain.editDocNumChange(Sender: TObject);
begin

  editResult.text:= '';

end;

//==============================================================================
procedure TformMain.comboBoxDocTypeChange(Sender: TObject);
begin

  editResult.text:= '';
  comboBoxUF.Enabled:= ( comboBoxDocType.ItemIndex = certex_doc_type_IE );

end;

end.
