unit uAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TformAbout = class(TForm)
    panelInfo: TPanel;
    panelSA: TPanel;
    panelButtons: TPanel;
    imageIcon: TImage;
    labelProg: TLabel;
    labelCopyright: TLabel;
    labelSAwww: TLabel;
    groupBoxInfo: TGroupBox;
    buttonOk: TButton;
    panelMemo: TPanel;
    memoInfo: TMemo;
    procedure labelSAwwwClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  formAbout: TformAbout;

implementation
  uses
    certex_pas,
    shellApi;

{$R *.DFM}
//==============================================================================
procedure TformAbout.FormCreate(Sender: TObject);
  var
    cLic: string;
    FCertexLic: byte;
begin

  labelProg.Caption:= application.Title;
  imageIcon.Picture.Icon.Assign( application.Icon );
  buttonOk.Left:= ( panelButtons.ClientWidth - buttonOk.width ) div 2;

  FCertexLic:= certex_getLicType();
 //------------------------------
  memoInfo.Lines.Add( 'Nome: ' + certex_dll_name );
  memoInfo.Lines.Add( Format( 'Verso: %s', [ certex_dllVersion() ]) );
//ou
//  memoInfo.Lines.Add( Format( 'Verso: %d,%d', [ Hi( certex_getVersion()), Lo(certex_getVersion())]) );
  if ( FCertexLic =  certex_lic_TYPE_REGISTERED ) then begin
    memoInfo.Lines.Add( 'Liceniada para: ' + certex_licUser() );
    memoInfo.Lines.Add( 'Registro Nmero: ' + certex_licNum() );
  end else begin
    case FCertexLic of
      certex_lic_TYPE_AS_DEMO:       cLic:= 'Chave no informada';
      certex_lic_TYPE_DEMO:          cLic:= 'Demo';
      certex_lic_ERROR_INVALID_KEY:  cLic:= 'Chave invlida';
      certex_lic_ERROR_NOT_INITED:   cLic:= 'DLL no inicializada';
      certex_lic_ERROR_CANT_RETRIVE: cLic:= 'No foi possvel obter informao';
      certex_lic_ERROR_NOT_FOUND:    cLic:= 'No encontrei informao';
      certex_lic_ERROR_CRC:          cLic:= 'Cuidado! Dll corrompida';
    else
      cLic:= Format( 'Erro %d', [FCertexLic] );
    end;
    memoInfo.Lines.Add( Format( 'Registro: Cpia de Avaliao (%s)', [cLic] ));
  end;


end;
//==============================================================================
procedure TformAbout.labelSAwwwClick(Sender: TObject);
begin

  shellExecute( 0, 'open', pChar(labelSAwww.caption), nil, nil, SW_SHOWNORMAL );

end;
end.
