unit certex_pas;

interface
 { Interface Esttica para CERTEX.DLL
   ou 'load-time dynamic linking to CERTEX.DLL',

   Certex.dll 1.0
   'Certex- A DLL que confere'
   Biblioteca Certificadora de Documentos

   (c) 2002 Software Atelier
       www.satelier.com.br

  //-----------------------
    Open Source Code
  //-----------------------
 }
  const
   { Tipos de Documentos }
    certex_doc_type_CNPJ=   0;
    certex_doc_type_CPF=    1;
    certex_doc_type_PIS=    2;     // Programa de Integrao Social
    certex_doc_type_TITULO= 3;     // Ttulo de Eleitor
    certex_doc_type_IE=     4;     // Inscrio Estadual
    certex_doc_type_CC=     5;     // Carto de Crdito

   { Resultados de certex_isValid() e certex_isCreditCard() }
    certex_result_VALIDO=                  0;
    certex_result_INVALIDO=                1;
    certex_result_TIPO_DOC_DESCONHECIDO=   2;
    certex_result_SEM_NUM_DOC=             3;
    certex_result_NUM_DOC_CHR_INVALIDO=    4;
    certex_result_NUM_DOC_LEN_INVALIDO=    5;
    certex_result_UF_DESCONHECIDA=         6;
    certex_result_MUNICIPIO_DESCONHECIDO=  7;
    certex_result_DESCONHECIDO=           10;

   { Resultados de certex_getLicType() }
    certex_lic_ERROR_UNKNOW=        0;
    certex_lic_TYPE_REGISTERED=     1;
    certex_lic_TYPE_DEMO=           2;
    certex_lic_TYPE_AS_DEMO=        3;
    certex_lic_ERROR_NOT_INITED=    4;
    certex_lic_ERROR_CANT_RETRIVE=  5;
    certex_lic_ERROR_NOT_FOUND=     6;
    certex_lic_ERROR_CRC=           7;
    certex_lic_ERROR_INVALID_KEY=   8;

   { Solicitaes para certex_getLicInfo() }
    certex_lic_info_USER_NAME=    1;
    certex_lic_info_USER_ID=      2;

   { Resultados de certex_isDigit() }
    certex_digits_OK=           0;
    certex_digits_INVALIDO=     1;
    certex_digits_FALTAM=       2;
    certex_digits_SOBRAM=       3;
    certex_digits_ERRO=         4;

   { Counts }
    certex_UF_Count=          27;
    certex_Doc_Type_Count=     6;

   { Size }
    certex_max_flag_size=     14;

  const
    certex_dll_name= 'certex.dll';

//------------------------------------------------------------------------------
 {--- DLL exported --- }
 { Informao DLL }
  function certex_getVersion(): word; stdcall; external certex_dll_name;
  function certex_getLicType( const lpLicKey: pChar =nil ): byte; stdcall; external certex_dll_name;

 { Validao }
  function certex_isValid( const nDocType: byte; const lpDocUF, lpDocNum: pChar ): byte; stdcall; external certex_dll_name;
  function certex_isDigit( const nDocType: byte; const lpDocUF, lpDocNum: pChar; var iDigit: integer ): byte; stdcall; external certex_dll_name;

 { Formatao }
  function certex_getQntDigits( const nDocType: byte; const lpDocUF, lpDocNum: pChar): byte; stdcall; external certex_dll_name;

//------------------------------------------------------------------------------
 {--- Pascal string, implemented here ---}

 { Informao DLL }
	function certex_licUser(): string;
  function certex_licNum(): string;
  function certex_dllVersion(): string;

 { Validao }
  function certex_creditCardFlag( const lpDocNum: pChar ): string;

 { Formatao }
  function certex_format( const nDocType: byte; const lpDocUF, lpDocNum: pChar ): string;

 { Auxiliares }
  function certex_ufName( const nUF: byte; const bShort: boolean ): string;
  function certex_docName( const nDocType: byte ): string;

implementation
  uses
    sysUtils;

 {--- Hidden DLL exported --- }
  function certex_getLicInfo( const nInfoType: byte; const wBufferLen: longWord; lpBuffer: pChar ): longWord; stdcall; external certex_dll_name;

  function certex_getFormat( const nDocType: byte; const lpDocUF, lpDocNum: pChar; const wBufferLen: longWord; lpBuffer: pChar): longWord; stdcall; external certex_dll_name;
  function certex_setFormat( const nDocType: byte; const lpDocUF, lpDocNum: pChar; const wBufferLen: longWord; lpBuffer: pChar): longWord; stdcall; external certex_dll_name;

  function certex_getUFName( const n: byte; const bShort: integer; lpBuffer: pChar ): longWord; stdcall; external certex_dll_name;
  function certex_getDocName( const nDocType: byte; const wBufferLen: longWord; lpBuffer: pChar): longWord; stdcall; external certex_dll_name;

  function certex_isCreditCard( const lpCC_Num: pChar; const wBufferLen: longWord; lpBuffer: pChar): byte; stdcall; external certex_dll_name;

//==============================================================================
function licInfo( const nInfoType: byte ): string;
  var
    iSize: integer;
begin

  iSize:= certex_getLicInfo( nInfoType, 0, nil );
  if ( iSize = 0 ) then begin
    result:= '';
  end else begin
    setLength( result, iSize );
    certex_getLicInfo( nInfoType, iSize, pChar( result ) );
  end;

end;

//==============================================================================
function certex_licUser(): string;
begin

  result:= licInfo( certex_lic_info_USER_NAME );

end;

//==============================================================================
function certex_licNum(): string;
begin

  result:= licInfo( certex_lic_info_USER_ID );

end;

//==============================================================================
function certex_dllVersion(): string;
  var
    wVer: word;
begin

  wVer:= certex_getVersion();
  result:= Format( '%d%s%d', [ hi( wVer ), DecimalSeparator, low( wVer )]);

end;

//==============================================================================
function certex_format( const nDocType: byte; const lpDocUF, lpDocNum: pChar ): string;
begin
                                          // o primeiro caracter de lpDocNum  importante em Ins Est
  setLength( result, certex_getFormat( nDocType, lpDocUF, lpDocNum, 0, nil ));
  certex_setFormat( nDocType, lpDocUF, lpDocNum, length( result ), pChar(result) );

end;

//==============================================================================
function certex_ufName( const nUF: byte; const bShort: boolean ): string;
  const
    intBool: array [ boolean ] of integer= ( 0, -1 );
  var
    iSize: integer;
begin

  iSize:= certex_getUFName( nUF, intBool[ bShort ], nil );
  if ( iSize = 0 ) then begin
    result:= '';
  end else begin
    setLength( result, iSize );
    certex_getUFName( nUF, intBool[ bShort ], pChar( result ));
  end;

end;

//==============================================================================
function certex_docName( const nDocType: byte ): string;
  var
    buffer: array[ 0..80 ] of char;
begin

  if ( certex_getDocName( nDocType, sizeOf( buffer ), buffer ) > 0 ) then begin
    result:= buffer;
  end else begin
    result:= '';
  end;

end;

//==============================================================================
function certex_creditCardFlag( const lpDocNum: pChar ): string;
  var
    buffer: array[ 0..certex_max_flag_size ] of char;
begin

  if not ( certex_isCreditCard( lpDocNum, sizeOf( buffer ), buffer ) = certex_result_VALIDO ) then begin
    result:= '';
  end else if ( buffer[0] = #0 ) then begin
    result:= 'Bandeira desconhecida';
  end else begin
    result:= buffer;
  end;

end;

end.

