/*

  Certex.DLL C++Builder Example

  (c) 2002 Software Atelier
      www.satelier.com.br

*/

//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#include "uMain.h"
#include "uAbout.h"
#include "certex.h"

#define _destroyMe  2

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TformMain *formMain;

byte FCertexLic;

//---------------------------------------------------------------------------
__fastcall TformMain::TformMain(TComponent* Owner)
    : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TformMain::buttonCloseClick(TObject *Sender)
{
  Application->Terminate();
}

//---------------------------------------------------------------------------
void __fastcall TformMain::buttonAboutClick(TObject *Sender)
{

 // se no existe, criar
  if ( formAbout == NULL ) {
    formAbout = new TformAbout(Application);
    formAbout->Tag= _destroyMe;
  }

 // centralizar
  formAbout->Left= Left + ( Width - formAbout->Width ) / 2;
  formAbout->Top=  Top + ( Height - formAbout->Height ) / 2;

  formAbout->ShowModal();

}

//---------------------------------------------------------------------------
void __fastcall TformMain::FormClose(TObject *Sender, TCloseAction &Action)
{

  if (!( formAbout == NULL ) && ( formAbout->Tag == _destroyMe )){
    delete formAbout;
  }
}
//---------------------------------------------------------------------------

void __fastcall TformMain::editDocNumChange(TObject *Sender)
{

  editResult->Text= "";

}

//---------------------------------------------------------------------------
void __fastcall TformMain::comboBoxDocTypeChange(TObject *Sender)
{

  editResult->Text= "";
  comboBoxUF->Enabled= ( comboBoxDocType->ItemIndex == certex_doc_type_IE );

}
//---------------------------------------------------------------------------
void __fastcall TformMain::FormCreate(TObject *Sender)
{
  char buffer[ 128 ];

  staticTextInfo->Caption= Application->Title;

 // Inicializar DLL, aqui pasar a chave de Registro obtida via e-mail
  FCertexLic= certex_getLicType( NULL /*"LicKey"*/ );
 // Para conhecer os posiveis valores de retorno, ver buttonAboutClick

  // Carregar tipos de documentos que Certex Verifica
  for (byte i= 0; i < certex_Doc_Type_Count; i++){
    certex_getDocName( i, sizeof( buffer ), buffer );
    comboBoxDocType->Items->Add( buffer );
  }
  comboBoxDocType->ItemIndex= 0;

 // Carregar os UF (sigla, extenso)
  for (byte i= 0; i < certex_UF_Count; i++){
    int n= certex_getUFName( i, true, buffer );    // sigla da UF
    StrCat( buffer, ", " );                    //  ,
    certex_getUFName( i, false, buffer + n + 2 );  // extenso da UF
    comboBoxUF->Items->Add( buffer );
  }
  comboBoxUF->ItemIndex= 0;

}
//---------------------------------------------------------------------------
void __fastcall TformMain::buttonVerifyClick(TObject *Sender)
{
  byte iResult;
  byte iTipoDoc= (byte)comboBoxDocType->ItemIndex;

 //---- Na verso de Avaliao, demora em dar o resultado
 //     mostrar ao usuario a demora (no seja que  impaciente e ctrl + alt + del
  if ( FCertexLic != certex_lic_TYPE_REGISTERED ){
    editResult->Text= "Conferindo... (verso demo)";
    editResult->Refresh();
    Screen->Cursor= crHourGlass;
    buttonVerify->Enabled= false;
  }

 //---- Verificar
  iResult= certex_isValid( iTipoDoc, comboBoxUF->Text.c_str(), editDocNum->Text.c_str() );

 //---- voltar mouse, etc
  if ( FCertexLic != certex_lic_TYPE_REGISTERED ){
    Screen->Cursor= crDefault;
    buttonVerify->Enabled= true;
  }

  //---- Mostrar resultado
  if ( iResult == certex_result_VALIDO ){
    int nSize= 1 + certex_getFormat( iTipoDoc, comboBoxUF->Text.c_str(), editDocNum->Text.c_str(), 0, NULL );
    char *buffer= new char[ nSize ];
    certex_setFormat( iTipoDoc, comboBoxUF->Text.c_str(), editDocNum->Text.c_str(), nSize, buffer );
    editResult->Text= buffer;
    delete buffer;
    if ( iTipoDoc != certex_doc_type_CC ){
      editResult->Text=  editResult->Text + " Ok!";
    }
    else{ // achar bandeira
      char buffer[ 4 + ( certex_max_flag_size > 20 ? certex_max_flag_size: 21 ) ];
      StrCopy( buffer, " (" );
      certex_isCreditCard( editDocNum->Text.c_str(), sizeof( buffer ), buffer+2 );
      editResult->Text= editResult->Text + StrCat( buffer, buffer[2] == 0 ? "Bandeira Desconhecida)": ")"  );
    }
  }
  else { //documento invlido, mostrar razo
    MessageBeep( MB_ICONEXCLAMATION );
    switch (iResult) {
      case certex_result_INVALIDO:              editResult->Text= comboBoxDocType->Text + " invlido(a)."; break;
      case certex_result_SEM_NUM_DOC:           editResult->Text= "Informe o nmero de documento."; break;
      case certex_result_TIPO_DOC_DESCONHECIDO: editResult->Text= "Tipo de documento desconhecido."; break;
      case certex_result_UF_DESCONHECIDA:       editResult->Text= "Unidade Federativa desconhecida."; break;
      case certex_result_NUM_DOC_CHR_INVALIDO:
        editResult->Text= "Caracter invlido encontrado no nmero.";
        {
          int iDigit;
          certex_isDigit( iTipoDoc, comboBoxUF->Text.c_str(), editDocNum->Text.c_str(), &iDigit );
          editDocNum->SetFocus();
          editDocNum->SelStart= iDigit;
          editDocNum->SelLength= 1;
        }
        break;
      case certex_result_NUM_DOC_LEN_INVALIDO:
        editResult->Text= "Nmero invlido de digitos.";
        if ( iTipoDoc != certex_doc_type_CC )
          editResult->Text= editResult->Text + " Esperados " + IntToStr( certex_getQntDigits( iTipoDoc, comboBoxUF->Text.c_str(), editDocNum->Text.c_str() ));
        break;
      default:
        editResult->Text= "Documento invlido (Erro: " + IntToStr( iResult ) + ")";
    }
  }

}
//---------------------------------------------------------------------------

