/*==========================================================
   Interface para CERTEX.DLL

   Certex.dll 1.0
   'Certex- A DLL que confere'
   Biblioteca Certificadora de Documentos

   (c) 2002 Software Atelier
       www.satelier.com.br

==============================================================*/
   // Tipos de Documentos
    #define certex_doc_type_CNPJ    0
    #define certex_doc_type_CPF     1
    #define certex_doc_type_PIS     2     // Programa de Integrao Social
    #define certex_doc_type_TITULO  3     // Ttulo de Eleitor
    #define certex_doc_type_IE      4     // Inscrio Estadual
    #define certex_doc_type_CC      5     // Carto de Crdito

   // Resultados de certex_isValid() e certex_isCreditCard()
    #define certex_result_VALIDO                   0
    #define certex_result_INVALIDO                 1
    #define certex_result_TIPO_DOC_DESCONHECIDO    2
    #define certex_result_SEM_NUM_DOC              3
    #define certex_result_NUM_DOC_CHR_INVALIDO     4
    #define certex_result_NUM_DOC_LEN_INVALIDO     5
    #define certex_result_UF_DESCONHECIDA          6
    #define certex_result_MUNICIPIO_DESCONHECIDO   7
    #define certex_result_DESCONHECIDO            10

   // Resultados de certex_getLicType()
    #define certex_lic_ERROR_UNKNOW         0
    #define certex_lic_TYPE_REGISTERED      1
    #define certex_lic_TYPE_DEMO            2
    #define certex_lic_TYPE_AS_DEMO         3
    #define certex_lic_ERROR_NOT_INITED     4
    #define certex_lic_ERROR_CANT_RETRIVE   5
    #define certex_lic_ERROR_NOT_FOUND      6
    #define certex_lic_ERROR_CRC            7
    #define certex_lic_ERROR_INVALID_KEY    8

   // Solicitaes para certex_getLicInfo()
    #define certex_lic_info_USER_NAME   1
    #define certex_lic_info_USER_ID     2

   // Resultados de certex_isDigit()
    #define certex_digits_OK            0
    #define certex_digits_INVALIDO      1
    #define certex_digits_FALTAM        2
    #define certex_digits_SOBRAM        3
    #define certex_digits_ERRO          4

   // Counts
    #define certex_UF_Count            27
    #define certex_Doc_Type_Count       6

   // Size
    #define certex_max_flag_size       14

    #define certex_dll_name       "certex.dll"

   // Public Certex exports
    #define certexAPI  __declspec(dllimport)
    #define APIcall    __stdcall
    #define _WORD     unsigned short int

#ifdef __cplusplus
    extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

//------- DLL exported Public Declarations
//-- Informao DLL
 certexAPI _WORD APIcall certex_getVersion();
 certexAPI BYTE  APIcall certex_getLicType( const LPTSTR lpLicKey );
 certexAPI DWORD APIcall certex_getLicInfo( const byte nInfoType, const DWORD wBufferLen, LPTSTR lpBuffer );

//-- Validao
 certexAPI BYTE  APIcall certex_isValid( const byte nDocType, const LPTSTR lpDocUF, const LPTSTR lpDocNum );
 certexAPI BYTE  APIcall certex_isCreditCard( const LPTSTR lpCC_Num, const DWORD wBufferLen, LPTSTR lpBuffer );
 certexAPI BYTE  APIcall certex_isDigit( const byte nDocType, const LPTSTR lpDocUF, const LPTSTR lpDocNum, int* iDigit );

//-- Formatao
 certexAPI BYTE  APIcall certex_getQntDigits(  const byte nDocType, const LPTSTR lpDocUF, const LPTSTR lpDocNum );
 certexAPI DWORD APIcall certex_getFormat( const byte nDocType, const LPTSTR lpDocUF, const LPTSTR lpDocNum, const DWORD wBufferLen, LPTSTR lpBuffer );
 certexAPI DWORD APIcall certex_setFormat( const byte nDocType, const LPTSTR lpDocUF, const LPTSTR lpDocNum, const DWORD wBufferLen, LPTSTR lpBuffer );

//-- Auxiliares
 certexAPI DWORD APIcall certex_getDocName( const byte nDocType, const DWORD wBufferLen, LPTSTR lpBuffer );
 certexAPI DWORD APIcall certex_getUFName(  const byte nDocType, const int iShort, LPTSTR lpBuffer );



#ifdef __cplusplus
    }
#endif  /* __cplusplus */

